// clientView.cpp : implementation of the CClientView class
//

#include "stdafx.h"
#include "client.h"

#include "clientDoc.h"
#include "clientView.h"

#include "led.h"
#include "boite.h"
#include "CSink.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CClientView

IMPLEMENT_DYNCREATE(CClientView, CView)

BEGIN_MESSAGE_MAP(CClientView, CView)
	//{{AFX_MSG_MAP(CClientView)
	ON_WM_CREATE()
	ON_COMMAND(ID_TEST_STARTTEST, OnStarttest)
	ON_COMMAND(ID_TEST_GLS, OnTestGls)
	ON_COMMAND(ID_TEST_READVARIABLE, OnTestReadvariable)
	ON_COMMAND(ID_TEST_GETEQUIPLIST, OnTestGetEquipList)
	ON_COMMAND(ID_TEST_READCONTINUE, OnTestReadcontinue)
	ON_COMMAND(ID_TEST_WRITEVARIABLE, OnTestWritevariable)
	ON_COMMAND(ID_TEST_DRIVELED, OnTestDriveled)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CClientView construction/destruction

CClientView::CClientView()
{
	// TODO: add construction code here

}

CClientView::~CClientView()
{
}

BOOL CClientView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CClientView drawing

void CClientView::OnDraw(CDC* pDC)
{
	CClientDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// CClientView printing

BOOL CClientView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CClientView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CClientView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CClientView diagnostics

#ifdef _DEBUG
void CClientView::AssertValid() const
{
	CView::AssertValid();
}

void CClientView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CClientDoc* CClientView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CClientDoc)));
	return (CClientDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CClientView message handlers


int CClientView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;
	

	// Cration d'un objet IDispatch attacher au serveur ATL
	// dont le ProgID est SinkTest.SinkTest.1

	if (!m_sinkTest.CreateDispatch("CSinkTest.CSinkTest.1"))
	{
		TRACE0("Could not create COM component");
		return -1;
	}
	return 0;
}

void CClientView::OnStarttest() 
{
	LPADVISESINK adviseSink;
	LPDATAOBJECT dataObj;
	DWORD		 dwCookie;
	DWORD		 dwTime;
	FORMATETC	 fmt = {CF_BITMAP, NULL, DVASPECT_CONTENT, -1, TYMED_GDI};


	// Cration d'une classe CAdviseSink qui implmente l'interface
	// IAdvise du client MFC
	CAdviseSink* advise = new CAdviseSink(); 
	HRESULT hr = advise->QueryInterface(IID_IAdviseSink, (PVOID*)&adviseSink);
	_ASSERT(SUCCEEDED(hr) && adviseSink);

	// Appel de la mthode QueryInterface par Automation pour
	// rcuprer l'interface IDataObject du serveur automation ATL
	hr = m_sinkTest.m_lpDispatch->QueryInterface(IID_IDataObject, (PVOID*)&dataObj);
	_ASSERT(SUCCEEDED(hr) && dataObj);

	// Appel de la mthode DAdvise de l'interface IDataObject du serveur ATL
	// pour lui dire que le client veut tre notifier des modifications des donnees
	// On lui passe en paramtre le pointer sur l'interface IAdvise du client afin
	// que le serveur puisse l'appeller
	hr = dataObj->DAdvise(&fmt, 0, adviseSink, &dwCookie);
	_ASSERT(SUCCEEDED(hr));
	dwTime=GetTickCount();

	// Appel de la mthode StartTest du serveur ATL
	// Cette mthode crer un DataAdviseHolder et appel la
	// mthode SendOnDataChange comme dans l'exemple du
	// chapitre 10 de Inside OLE afin que le client soit
	// notifier. Cela provoque l'appel de la mthode OnDataChange
	// de l'interface IAdvise du client
	m_sinkTest.StartTest(1);


    dwTime=GetTickCount()-dwTime;
	CString msg;
	msg.Format("Time elapsed is %d seconds", dwTime/1000);
	MessageBox(msg);
	_ASSERT(SUCCEEDED(hr));

	// Fermeture de la connexion du client avec le serveur
	// Le client ne sera plus notifier des modifications des donnees
	// du serveur
	dataObj->DUnadvise(dwCookie);

	adviseSink->Release();
	dataObj->Release();
//	delete advise;
}


void CClientView::OnTestGls() 
{
	// TODO: Add your command handler code here
    short Langue;
	long rc;

    m_sinkTest.GetLangueSystem(&Langue, &rc);
	CString msg;
	msg.Format("Langue is %s", (char *)(&Langue));
	MessageBox(msg);
	
}


void CClientView::OnTestReadvariable() 
{
	// TODO: Add your command handler code here
	CBoite *pB = new CBoite;
	pB->m_pSinkTest = &m_sinkTest;
	pB->m_lecture = TRUE;
	pB->m_bReadCont = FALSE;
	pB->DoModal();
	delete pB;
}

void CClientView::OnTestGetEquipList() 
{
	long l, i, rc;
	VARIANT v1, v2;
	//VARIANT *pv1, *pv2;
	AfxVariantInit(&v1);
	AfxVariantInit(&v2);
	//pv1 = &v1;
	//pv2 = &v2;
	BSTR s;
	CWnd msg;
	char buf[32];
	char fulbuf[128]= "";

	COleSafeArray sa;
	// TODO: Add your command handler code here
	m_sinkTest.GetEquipmentList(&l, &v1, &v2, &rc);
	sa.Attach(v1);
	for (i = 0; i < l; i++)
	{
		sa.GetElement(&i, &s);
		wcstombs(buf, s, 128);
		strcat (fulbuf, "-");
		strcat (fulbuf, buf);
		strcat (fulbuf, "-");
	}
	msg.MessageBox(fulbuf);
}

void CClientView::OnTestReadcontinue() 
{
	// TODO: Add your command handler code here
	CBoite *pB = new CBoite;
	pB->m_pSinkTest = &m_sinkTest;
	pB->m_lecture = TRUE;
	pB->m_bReadCont = TRUE;
	pB->DoModal();
	delete pB;
	
}

void CClientView::OnTestWritevariable() 
{
	// TODO: Add your command handler code here
	CBoite *pB = new CBoite;
	pB->m_pSinkTest = &m_sinkTest;
	pB->m_lecture = FALSE;
	pB->m_bReadCont = FALSE;
	pB->DoModal();
	delete pB;
	
}

void CClientView::OnTestDriveled() 
{
	// TODO: Add your command handler code here
	CLed *pB = new CLed;
	pB->m_pSinkTest = &m_sinkTest;
	pB->DoModal();
	delete pB;
	
}
